function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 279);

T = World_Economy_Cartel_cost_inv_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(243) = T(45)+T(56)+params(32)*y(121)*exp(y(36))*params(6)*exp(y(116))*params(5)*params(5)*exp(params(5)*y(40));
T(244) = getPowerDeriv(T(9),T(10),3);
T(245) = T(152)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(246) = T(5)*T(245);
T(247) = T(144)+T(143)+exp(y(45))*(T(142)+exp(y(45))*exp(y(45))*getPowerDeriv(exp(y(45)),T(11),3));
T(248) = y(67)*(-(T(89)*T(19)*T(16)*exp(T(1)*y(52))*(1-params(11))*params(3)*T(144)+T(5)*T(19)*T(91)*exp(T(1)*y(52))*(1-params(11))*params(3)*T(144)))+y(66)*(-(T(93)*T(3)*T(16)*exp(T(1)*y(52))*(1-params(11))*(1-params(3))*T(144)+T(17)*T(3)*T(91)*exp(T(1)*y(52))*(1-params(11))*(1-params(3))*T(144)));
T(249) = y(67)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))*T(144)))+y(66)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))*T(144)));
T(250) = T(155)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(251) = y(67)*(-(T(5)*(T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))*T(155)+T(19)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))*T(90)*T(153))))+y(66)*(-(T(17)*(T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))*T(152)+T(3)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))*T(90)*T(153))));
T(252) = y(67)*(-(T(89)*T(19)*T(61)*T(91)+T(19)*T(16)*T(61)*T(190)+T(89)*T(19)*T(61)*T(91)+T(5)*T(19)*T(61)*T(191)))+y(66)*(-(T(93)*T(3)*T(62)*T(91)+T(17)*T(3)*T(62)*T(191)+T(93)*T(3)*T(62)*T(91)+T(3)*T(16)*T(62)*T(195)));
T(253) = y(67)*(-(T(89)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))+T(5)*T(19)*T(91)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(52))))+y(66)*(-(T(17)*T(3)*T(91)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))+T(93)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(52))));
T(254) = y(67)*(-(T(5)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(52))))+y(66)*(-(T(17)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(52))));
T(255) = getPowerDeriv(T(71),T(10),3);
T(256) = T(149)+exp(y(109))*exp(y(109))*getPowerDeriv(exp(y(109)),T(11),2);
T(257) = (1-params(11))*(1-params(3))*exp(T(1)*y(114))*T(256);
T(258) = T(168)+T(167)+T(20)*(T(166)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(259) = getPowerDeriv(T(67),T(1),3);
T(260) = getPowerDeriv(T(67),T(13),3);
T(261) = T(64)*T(168)*T(64)*T(65)*T(171)+T(77)*T(64)*T(258)+T(64)*T(168)*T(64)*T(65)*T(171)+T(64)*T(65)*(T(64)*T(168)*T(171)+T(64)*T(65)*T(64)*T(65)*T(260));
T(262) = T(64)*T(168)*T(171)*T(66)*T(206)+T(77)*T(168)*T(206)+T(64)*T(65)*T(171)*T(65)*T(206)+T(64)*T(65)*(T(171)*T(65)*T(206)+T(64)*T(65)*T(66)*T(206)*T(260));
T(263) = T(206)+exp(y(110))*exp(y(110))*getPowerDeriv(exp(y(110)),1-params(3),2);
T(264) = T(65)*T(206)*T(171)*T(66)*T(206)+T(77)*T(65)*T(263)+T(65)*T(206)*T(171)*T(66)*T(206)+T(64)*T(65)*(T(66)*T(206)*T(66)*T(206)*T(260)+T(171)*T(66)*T(263));
T(265) = getPowerDeriv(T(6),T(13),3);
T(266) = T(89)*T(152)*T(153)*T(158)+T(90)*T(89)*T(245)+T(89)*T(152)*T(153)*T(158)+T(3)*T(89)*(T(158)*T(246)+T(153)*T(153)*T(265));
T(267) = getPowerDeriv(T(6),T(1),3);
T(268) = getPowerDeriv(T(30),(-params(14)),2);
T(269) = T(178)*(-(params(9)*(T(176)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(177)*T(177)*T(268);
T(270) = T(31)*exp(y(15))*T(178)+T(31)*exp(y(15))*T(178);
T(271) = getPowerDeriv(T(28),(-params(14)),3);
T(272) = T(185)*T(84)*T(186)+T(85)*(-(params(9)*(T(184)+T(183)+T(4)*(T(182)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(185)*T(84)*T(186)+T(84)*(T(185)*T(186)+T(84)*T(84)*T(271));
T(273) = T(190)+T(189)+T(4)*(T(188)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(274) = T(3)*T(190)*T(3)*T(89)*T(158)+T(90)*T(3)*T(273)+T(3)*T(190)*T(3)*T(89)*T(158)+T(3)*T(89)*(T(158)*T(3)*T(190)+T(3)*T(89)*T(3)*T(89)*T(265));
T(275) = getPowerDeriv(T(97),(-params(14)),2);
T(276) = params(1)*(T(212)*(-(params(9)*(T(210)+exp(y(110))*exp(y(110))*getPowerDeriv(exp(y(110)),1+params(8),2))/(1+params(8))))+T(211)*T(211)*T(275));
T(277) = y(67)*(-(T(89)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(52))+T(5)*T(19)*T(91)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(52))));
T(278) = y(66)*(-(T(93)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(52))+T(17)*T(3)*T(91)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(52))));
T(279) = T(219)+exp(y(48))*exp(y(48))*T(186)+exp(y(48))*(exp(y(48))*T(186)+exp(y(48))*exp(y(48))*T(271));

end
